/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         
         
         // make an array of the draggable symbol names
            var numbers = ['wake','teeth','shower','clothes'];
            // make an array of the droppable element names
            var targets = ['home1','home2','home3','home4'];
            // have only the first element be draggable
         
         var Pos = [
         {'x':498,'y':293},
         {'x':41,'y':293},
         {'x':198,'y':293},
         {'x':349,'y':293}
            ];
         
         k=0;
         
           // set up the droppable to accept each draggables
            for (i=0;i<numbers.length;i++){	
            	sym.$(numbers[i]).css({"left":Pos[i].x,"top":Pos[i].y,"position":"absolute"})
            	sym.$(numbers[i]).addClass('C'+i);
            	sym.$('.C'+i).draggable({
            	revert: 'invalid', opacity:1,
            	   	});
            sym.$(targets[i]).droppable({
            		accept:'.C'+i,   // use class for accept
            		drop: handleDropEvent
         
            	});
         
            }
         
         
         function handleDropEvent(event, ui){		
                ui.draggable.draggable( 'disable' );
                $(this).droppable( 'disable' );
                // place draggable where needed. could be left, top
               // ui.draggable.position( { of: $(this), my: 'left', at: 'top' } );
                ui.draggable.position( { of: $(this), my: 'center', at: 'middle' } );
                ui.draggable.draggable( 'option', 'revert', false );
         
         
               var p = ui.draggable.attr("id");
         
               k++;	 
         
         
         		playsound(p);
         		checkAnimation();
         
            }
         
         
         function checkAnimation(){
         	if (k==4){
         
          		  sym.getSymbol("Symbol_1").play();
          		  setTimeout(function(){sym.$("welldonesound")[0].play();}, 1500);
          		setTimeout(function(){sym.$("btn_reset1").show();}, 4500);
          		 setTimeout(function(){sym.$("next_arrow2").show();}, 4500);
         
         
         	}
         
         }
         
         
         
         
         
         
         	function playsound(r){
         
           if(r=='Stage_wake'){
         
         			sym.$("Soundwake")[0].currentTime = 0;
         		if (sym.$("Soundwake")[0].paused) 
         				{
         				sym.$("Soundwake")[0].play();
         				}
         
         			}
         
              if(r=='Stage_teeth'){
         
         			sym.$("Soundteeth")[0].currentTime = 0;
         			if (sym.$("Soundteeth")[0].paused) 
         			{
         			sym.$("Soundteeth")[0].play();
         			}
         		}
         
         		if(r=='Stage_shower'){
         
         			sym.$("newshower")[0].currentTime = 0;
         			if (sym.$("newshower")[0].paused) 
         			{
         			sym.$("newshower")[0].play();
         			}
         		}
         
         
         		if(r=='Stage_clothes'){
         
         			sym.$("Soundclothes")[0].currentTime = 0;
         			if (sym.$("Soundclothes")[0].paused) 
         			{
         			sym.$("Soundclothes")[0].play();
         			}
         		}
         
         	}
         
         sym.$('btn_reset1').click(function(){
            	window.location.reload()
            });
         
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      

      

      Symbol.bindElementAction(compId, symbolName, "${early}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("Soundwake")[0].currentTime = 0;
         		if (sym.$("Soundwake")[0].paused) 
         				{
         				sym.$("Soundwake")[0].play();
         				}

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${brush}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("Soundteeth")[0].currentTime = 0;
         		if (sym.$("Soundteeth")[0].paused) 
         				{
         				sym.$("Soundteeth")[0].play();
         				}

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${shower1}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("newshower")[0].currentTime = 0;
         			if (sym.$("newshower")[0].paused) 
         			{
         			sym.$("newshower")[0].play();
         			}

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${clothes1}", "click", function(sym, e) {
         // insert code for mouse click here
         
         
         			sym.$("Soundclothes")[0].currentTime = 0;
         			if (sym.$("Soundclothes")[0].paused) 
         			{
         			sym.$("Soundclothes")[0].play();
         			}

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${socks}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("Soundsocks")[0].currentTime = 0;
         		if (sym.$("Soundsocks")[0].paused) 
         				{
         				sym.$("Soundsocks")[0].play();
         				}

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${hair}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("Soundhair")[0].currentTime = 0;
         		if (sym.$("Soundhair")[0].paused) 
         				{
         				sym.$("Soundhair")[0].play();
         				}

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${take}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("Soundbreakfast")[0].currentTime = 0;
         		if (sym.$("Soundbreakfast")[0].paused) 
         				{
         				sym.$("Soundbreakfast")[0].play();
         				}

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${school}", "click", function(sym, e) {
         // insert code for mouse click here
         sym.$("Soundschool")[0].currentTime = 0;
         		if (sym.$("Soundschool")[0].paused) 
         				{
         				sym.$("Soundschool")[0].play();
         				}

      });
      //Edge binding end

      

      

      

      Symbol.bindElementAction(compId, symbolName, "${next_arrow2}", "click", function(sym, e) {
         // insert code for mouse click here
         
         // Navigate to a new URL in the current window
         // (replace "_self" with appropriate target attribute)
         window.open("page2.html","_self");

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'btn_reset'
   (function(symbolName) {   
   
   })("btn_reset");
   //Edge symbol end:'btn_reset'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

   //=========================================================
   
   //Edge symbol: 'Symbol_2'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("Symbol_2");
   //Edge symbol end:'Symbol_2'

   //=========================================================
   
   //Edge symbol: 'Symbol_22'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("Symbol_22");
   //Edge symbol end:'Symbol_22'

   //=========================================================
   
   //Edge symbol: 'Symbol2'
   (function(symbolName) {   
   
   })("Symbol2");
   //Edge symbol end:'Symbol2'

   //=========================================================
   
   //Edge symbol: 'Symbol22'
   (function(symbolName) {   
   
   })("Symbol22");
   //Edge symbol end:'Symbol22'

   //=========================================================
   
   //Edge symbol: 'Symbol222'
   (function(symbolName) {   
   
   })("Symbol222");
   //Edge symbol end:'Symbol222'

   //=========================================================
   
   //Edge symbol: 'Symbol221'
   (function(symbolName) {   
   
   })("Symbol221");
   //Edge symbol end:'Symbol221'

   //=========================================================
   
   //Edge symbol: 'btn_reset1'
   (function(symbolName) {   
   
   })("btn_reset1");
   //Edge symbol end:'btn_reset1'

   //=========================================================
   
   //Edge symbol: 'btn_reset2'
   (function(symbolName) {   
   
   })("btn_reset2");
   //Edge symbol end:'btn_reset2'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "EDGE-18268291");